#version 330
#extension GL_EXT_gpu_shader4 : enable
// fractal directoMod01.fsh  by jorge2017a1 
//https://www.shadertoy.com/view/tttcDX
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//referencia
//http://glslsandbox.com/e#70359.0
//modificado por jorge2017a1

#define rot(a) mat2(cos(a), sin(a), -sin(a), cos(a))

float scale;


float map(vec3 p) 
{
    vec3 pp=p;
	p.z -= -iTime *1.0;
	p.xy = abs(p.xy) - 1.0;
	if (p.x < p.y) p.xy = p.yx;
	p.z = mod(p.z, 4.0) - 2.0;

	p.x -= 3.2;
	p = abs(p);
	float s = 2.0;
	 vec3 offset =p*1.5;
    
    float r;
    
	for (float i = 0.0; i < 5.0; i++)
    {
		p = 1.0 - abs(p - 1.0);
		 r = -7.5 * clamp(0.38 * max(1.2 / dot(p, p), 1.), 0.0, 1.0);
		s *= r;
		p *= r;
        p += offset;
	}
	s = abs(s);
	scale = s;
	float a = 100.0;
	p -= clamp(p, -a, a);
	return (length(p)) /( s);
}

vec3 GetNormal(vec3 p)
{
	float d = map(p);
    vec2 e = vec2(.001, 0);
    vec3 n = d - vec3(
        map(p-e.xyy),
        map(p-e.yxy),
        map(p-e.yyx));
    return normalize(n);
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 uv = (gl_FragCoord.xy - 0.5 * iResolution.xy) / iResolution.y;
	vec3 rd = normalize(vec3(uv, 1.0));
    vec3 ro=vec3(0, 0.5, -3);
	vec3 p = ro;
    scale=1.0;
     float d;
     
     //vec3 light_color1 = vec3( 1.0 );
     vec3 light_pos1= vec3(2.0, 3.0, 10.0 );
     vec3 final;
     float shininess=1.0;
     
	for (int i = 1; i < 100; i++) {
		float d = map(p);
		p += rd * d;
		if (d < 0.001) 
        {
	       
            vec3 color=mix(vec3(0.85), cos(vec3(2.0, 9., 3.) + log2(scale)) * 0.5 + 0.5, 0.5) * 10.0 / float(i);
            
            vec3 normal=GetNormal(p);
            vec3 v = normalize( p-ro);
              float diff = dot(normal, light_pos1);
    
            vec3 vl = normalize( light_pos1 - p );
            vec3 ref_v = reflect( v, normal );
            float diffuse  = max( 0.0, dot( vl, normal ) );
            float specular = max( 0.0, dot( vl, ref_v ) );
    
            specular = pow( specular, shininess );
            
            final += color * ( diffuse + specular);
            
			break;
		}
        
        
	}
    
    
    gl_FragColor =vec4( final,1.0);
    
    gl_FragColor *= 1.0 - pow(d /(100.0) , 3.5);    
    gl_FragColor = pow(gl_FragColor, vec4(0.5545));  

    
}
